# -*- coding: utf-8 -*-
"""
Created on Tue May 21 14:40:29 2019

@author: adijkstra
"""
"""
NOTE!!!! THIS CODE ONLY WORKS WHEN YOUR X-AXIS DATA IS EQUALLY SPACED
"""

import numpy as np
from numpy import exp, linspace, random
import pandas as pd
import matplotlib.pyplot as plt
import os
from scipy.optimize import curve_fit
from scipy.special import gamma
from scipy import signal
from scipy.ndimage import convolve1d
from scipy.ndimage import correlate1d

#============Get the current directory
path = os.getcwd()
print("The current directory is: %s" % path )
#==================================================================



#specify from which file the data comes
fileNamePow ='H06138_LICorrIntensityPowers.txt'
importedFilePow=np.array(pd.read_csv(fileNamePow, sep='\t', header=None))
#importedFilePow=np.array(pd.read_csv(fileNamePow, sep='\t', header=None))

#select the data desired
#Energy scale
energyData = importedFilePow[7:,1]
energyData = energyData.astype(np.float)  #turn into a float data format



def gaussian(x, amp, cen, wid, y0=0.0, normalized=False):
    if normalized == False:
        return y0 + np.divide(amp * np.exp(-(4*np.log(2))*np.power((x-cen),2) / np.power(wid,2)), wid*np.sqrt(np.divide(np.pi,(4*np.log(2)))))
    elif normalized == True:
        temp=y0 + np.divide(amp * np.exp(-(4*np.log(2))*np.power((x-cen),2) / np.power(wid,2)), wid*np.sqrt(np.divide(np.pi,(4*np.log(2)))))
        return np.divide(temp,np.amax(temp))

def biGaussian(x, height, cen, c1, c2, y0=0.0, normalized=False):
    #first calculate the lower side of the distribution
    output = y0 + height*np.exp(-np.power((x - cen),2)/(2*np.power(c1,2)))
    #Then find out to which element cen is closest to.
    closestElement=(np.abs(x - cen)).argmin()
    if (x[closestElement] - cen) >=0:
        closestElement=closestElement-1
    #Calculate all the values on the higher side of the distribution    
    output[closestElement:] = y0 + height*np.exp(-np.power((x[closestElement:] - cen),2)/(2*np.power(c2,2)))
    if normalized == False:
        return output
    elif normalized == True:
        return np.divide(output,np.amax(output))

def simpleDOS(E, Eg, A, normalized=True):
    if np.isscalar(E) == False:
        DOS=np.zeros(int(np.size(E)))
        n=0
        for i in E:
            if i<=Eg:
                DOS[n]=0.0
            else:
                DOS[n]=np.multiply(A,np.sqrt(i-Eg))
                
            n+=1
        return DOS     

    else:
        return np.multiply(A,np.sqrt(E-Eg))

    
def fermiDirac(E,Eg,T,Eshift=0):
    k=8.61733e-5 #[eV/K]
    return np.divide(1,(1+np.exp(np.divide((E-Eg-Eshift),(k*T)))))

def urbachTail(E, Eg, gam, theta=1, normalized=False):
    N=np.divide(1,(2*gam*gamma(1+np.divide(1,theta)))) #This normalization factor makes that the area under neath the graph remains to be 1
    if normalized == False:
        return np.multiply(np.exp(-np.power(np.absolute((np.divide((E-Eg),gam))),theta)),N)
    elif normalized == True:
        return np.divide(np.multiply(np.exp(-np.power(np.absolute((np.divide((E-Eg),gam))),theta)),N), np.amax(np.multiply(np.exp(-np.power(np.absolute((np.divide((E-Eg),gam))),theta)),N)))
    
    
def tailedDOS(E, Eg, A, gam, theta=1, normalized=False):
    #First make an array that will be used to define the urback tail, important is that I know the length of the array and that the peak is at te exact center
    EStepsize=np.divide((E[40]-E[0]),40) #Get the energy stepsize
    HalfLength = int(1000) #Choose a value for the length of the array used for the peak function 
    EDataUT = np.zeros(HalfLength*2) #define the array that will be used and fill the array with energy values with zero at the center of the array.
    for i in range (HalfLength):
        EDataUT[i]=(i-HalfLength+0.5)*EStepsize
        EDataUT[i+HalfLength]=(i+0.5)*EStepsize
    #Now the FULL convolution can be done between the urbach tail and the simple DOS    
    tailDOS=np.convolve(urbachTail(EDataUT, 0, gam, theta), simpleDOS(E, Eg, A), 'full')/sum(urbachTail(EDataUT, 0, gam, theta))
    #The convolution is now exactly shifted by half of the urbach tail length minus one cell So now I correct for this and we can return the array.
    tailDOS=tailDOS[HalfLength-1:]
    tailDOS=tailDOS[0:int(np.size(E))]
    #Then return the signal
    if normalized == False:
        return tailDOS
    elif normalized == True:
        return np.divide(tailDOS,np.amax(tailDOS))
    
def simpleDOS_FD(E, Eg, A, T, Eshift=0, normalized=False):
    if normalized == False:
        return np.multiply(simpleDOS(E,Eg,A),fermiDirac(E,Eg,T, Eshift))
    elif normalized == True:
        return np.divide(np.multiply(simpleDOS(E,Eg,A),fermiDirac(E,Eg,T, Eshift)),np.amax(np.multiply(simpleDOS(E,Eg,A),fermiDirac(E,Eg,T, Eshift))))

def tailedDOS_FD(E, Eg, A, T, gam, theta=1, Eshift=0.0, normalized=False):
    if normalized == False:
        return np.multiply(tailedDOS(E, Eg, A, gam, theta),fermiDirac(E,Eg,T,Eshift))
    elif normalized == True:
        return np.divide(np.multiply(tailedDOS(E, Eg, A, gam, theta),fermiDirac(E,Eg,T,Eshift)),np.amax(np.multiply(tailedDOS(E, Eg, A, gam, theta),fermiDirac(E,Eg,T,Eshift))))

def tailedAbsorptivity (E, Eg, A, gam, theta=1, Eshift=0, d=1, normalized=False):
    #d is a characeristic length scale of absorption
    if normalized == False:
        return 1-np.exp(-tailedDOS(E, Eg, A, gam, theta)*d)
    elif normalized == True:
        return np.divide((1-np.exp(-tailedDOS(E, Eg, A, gam, theta)*d)),np.amax(1-np.exp(-tailedDOS(E, Eg, A, gam, theta)*d)))
    
def simpleAbsorptivity (E, Eg, A, Eshift=0, d=1, normalized=False):
    #d is a characeristic length scale of absorption in paper used as fitting parameter
    if normalized == False:
        return 1-np.exp(-simpleDOS(E, Eg, A)*d)
    elif normalized == True:
        return np.divide((1-np.exp(-simpleDOS(E, Eg, A)*d)),np.amax(1-np.exp(-simpleDOS(E, Eg, A)*d)))
    
def tailedAbsortivityOccCorr(E, Eg, A, T, gam, Dmu, d=1, theta=1, Eshift=0, normalized=False):
    k=8.61733e-5 #[eV/K]
    #d is a characeristic length scale of absorption in paper used as fitting parameter
    temp=np.multiply(tailedDOS(E, Eg, A, gam, theta),(1-np.divide(2,np.exp(np.divide((E-Dmu),(2*np.multiply(k,T))))+1)))
    temp=1-np.exp(-temp*d)
    #temp=(1-np.divide(2,np.exp(np.divide((E-Dmu),(2*np.multiply(k,T))))+1))
    if normalized == False:
        return temp
    elif normalized == True:
        return np.divide(temp,temp[-1])
    
    
def LSW_tailedAbs_PL (E, Eg, A, T, gam, Dmu, d=1, theta=1, Eshift=0, normalized=False):
    k=8.61733e-5 #[eV/K]
    temp=np.divide(np.multiply(np.power(E,2),tailedAbsortivityOccCorr(E, Eg, A, T, gam, Dmu, d, theta, Eshift=0.0, normalized=False)),(np.exp(np.divide((E-Dmu),(np.multiply(k,T))))-1))
    #temp=np.divide(1,np.exp(np.divide((E-Dmu),(np.multiply(k,T))))-1)
    if normalized == False:
        return temp
    elif normalized == True:
        return np.divide(temp,np.amax(temp))
    
def LSW_tailedAbsNoCorr_PL (E, Eg, A, T, gam, Dmu, d=1, theta=1, Eshift=0, normalized=False):
    k=8.61733e-5 #[eV/K]
    temp=np.divide(np.multiply(np.power(E,2),tailedAbsorptivity(E, Eg, A, gam, theta, Eshift=0.0, normalized=False)),(np.exp(np.divide((E-Dmu),(np.multiply(k,T))))-1))
    #temp=np.divide(1,np.exp(np.divide((E-Dmu),(np.multiply(k,T))))-1)
    if normalized == False:
        return temp
    elif normalized == True:
        return np.divide(temp,np.amax(temp[3000:]))


#This is a scale I use to get a higher density of data points
energySimu = np.arange(0.01, 0.9, 0.0001)
energySimu = energySimu.astype(np.float)



###############################################################
#Fitting with the BI-GAUSSIAN
#Power dependent
####################################################


#==================Setting fitting parameters
biCenter=0.34
biHeight= 1
biOffset=0;
biCLeft=0.1
biCRight=0.02
#============================

#make a new directory of all the output of the PL_V_T data
path = os.getcwd()
print("The current directory is: %s" % path )
newnewfolderpath=path+"/BiGaussian_PL_fitting_P-series"
try:
    os.mkdir(newnewfolderpath)
except OSError:
    print('Creation of folder failed')
else:
    print('Succesfully created folder')
try:
    os.chdir(newnewfolderpath)
except OSError:
    print('Failed to change directories to new folder')
else:    
    print('Changed directory to new new folder: ' + newnewfolderpath)

#Check how many things I imported
importSizeTemp=np.size(importedFilePow[:1])-2

#Make result arrays existing out of zeros
results_biGauss_PL = np.zeros(((importSizeTemp),9),dtype=float)

#Make initial values
InVal_biGauss_PL = [biHeight, biCenter, biCLeft, biCRight]  # for [amp, cen, wid]

#Energy scale
energyData = importedFilePow[7:,1]
energyData = energyData.astype(np.float)  #turn into a float data format

#Loop to fit with the simple model
for i in range (0, importSizeTemp):
    #initialize fitting result array
    BestVal_biGauss_PL = np.zeros(4)
    
    #BestVal_DOS_FD, covar = curve_fit(simpleDOS_FD, energyData, importedFilePow[7:,i+2], p0=InVal_sDOS_FD)
    data=importedFilePow[7:,i+2]
    data = data.astype(np.float)
    data = np.divide(data, np.amax(data))
    FitStartElement=40
    FitEndElement=150
    
    try: BestVal_biGauss_PL, covar = curve_fit(biGaussian, energyData[FitStartElement:FitEndElement], data[FitStartElement:FitEndElement], p0=InVal_biGauss_PL)
    except:
        print("Something happend!")
        
    print(np.size(BestVal_biGauss_PL))    
    
    #Save the temperature of the spectrum to the fit and the fitting results
    results_biGauss_PL[i,1:5]=BestVal_biGauss_PL
    results_biGauss_PL[i,0]=importedFilePow[3,i+2]
    print("Finished with power: " + str(importedFilePow[4,i+2]))
    
    #Do some after processing to get aditional values like width and intensity
    #Calucluate the width left and right from the c1 and c2 values
    results_biGauss_PL[i,5]=np.multiply(np.sqrt(np.multiply(2,np.log(2))),results_biGauss_PL[i,3])
    results_biGauss_PL[i,6]=np.multiply(np.sqrt(np.multiply(2,np.log(2))),results_biGauss_PL[i,4])
    results_biGauss_PL[i,7]=results_biGauss_PL[i,6] + results_biGauss_PL[i,7]
    #Determine the intensity
    results_biGauss_PL[i,8]=np.multiply(results_biGauss_PL[i,1],(results_biGauss_PL[i,3]+results_biGauss_PL[i,4]))*np.sqrt(np.multiply(2,np.pi))
    
    
    if True:
        plt.figure(figsize=(10, 5))
        plt.subplot(1, 2, 1)
        plt.plot(energyData, data, 'r')
        plt.plot(energyData, biGaussian(energyData, BestVal_biGauss_PL[0], BestVal_biGauss_PL[1], BestVal_biGauss_PL[2], BestVal_biGauss_PL[3]), 'b--')
        plt.text(0.11, 1.15, "P = " + importedFilePow[4,i+2] + "mW" , horizontalalignment='left', verticalalignment='top', fontsize=18)
        plt.axvline(x=energyData[FitStartElement],linewidth=1.0, color='g')
        plt.axvline(x=energyData[FitEndElement],linewidth=1.0, color='g')
        plt.axis([0.1, 0.60, 0.0, 1.2])
        plt.subplot(1, 2, 2)
        plt.semilogy(energyData, data, 'r')
        plt.semilogy(energyData, biGaussian(energyData, BestVal_biGauss_PL[0], BestVal_biGauss_PL[1], BestVal_biGauss_PL[2], BestVal_biGauss_PL[3]), 'b--')
        plt.axvline(x=energyData[FitStartElement],linewidth=1.0, color='g')
        plt.axvline(x=energyData[FitEndElement],linewidth=1.0, color='g')
        plt.axis([0.1, 0.60, 0.001, 1.2])
        plt.savefig('BiGauss_PL_' + str(importedFilePow[4,i+2]) + 'mW.png')
        plt.show()
        


print(results_biGauss_PL)

#create a .txt file with the same name as the h5 file and save in the same location
Header='\r\n'.join(["Temperature\tHeight\tCenter\tc1\tc2\tW1\tW2\tFWHM\tIntensity", "K\t-\teV\teV\teV\teV\teV\teV\ta.u."])
np.savetxt("Fitting_results_" + fileNamePow + ".txt", results_biGauss_PL, fmt='%.5e', delimiter='\t', header=Header, newline='\r\n', comments='')


plt.figure(2, figsize=(6, 16), dpi=80, facecolor='w', edgecolor='k')

for i in range (0, importSizeTemp):
    data=importedFilePow[7:,i+2]
    data = data.astype(np.float)
    data = np.divide(data, np.amax(data))
    plt.plot(energyData, data+0.5*i, 'r')
    plt.plot(energyData, biGaussian(energyData, results_biGauss_PL[i,1], results_biGauss_PL[i,2], results_biGauss_PL[i,3], results_biGauss_PL[i,4], normalized=True)+0.5*i, 'b--')
    plt.text(0.79, 0.1+0.5*i, "T= " + str(importedFilePow[3,i+2]) + "K", horizontalalignment='right', verticalalignment='bottom', fontsize=12)
plt.axis([0.1, 0.6, 0, 17])
#save the figure in the current directory
plt.savefig('PL_BiGauss_PL_T-Stack.png')
plt.show
os.chdir(path)


#This is just a temorary check
plt.figure(3)
plt.plot(results_biGauss_PL[:,0],results_biGauss_PL[:,2], "b*", label="Peak center" )
plt.legend(loc="best")
plt.savefig('PL_BiGauss_PeakCenter.png')
plt.show()

